/*****************************************************************************/
/* Codec.c                                                                   */
/*                                                                           */
/* Digital Loopback example                                                  */
/*                                                                           */
/*****************************************************************************/

#include <type.h>
#include <board.h>
#include <codec.h>
#include <mcbsp54.h>

/*****************************************************************************/
/* Function Prototypes                                                       */
/*****************************************************************************/

/* This delay routine does not conflict with DSP/BIOS.  It is used in this  */
/* example rather than brd_delay_msec which causes DSP/BIOS conflicts just  */
/* because of this.  If you are not using DSP/BIOS, you can change the code */
/* to use brd_delay_msec.                                                   */

void delay(s16 period);


/*****************************************************************************/
/* Global Variables                                                          */
/*****************************************************************************/

HANDLE hHandset;
s16 data;


/*****************************************************************************/
/* MAIN                                                                      */
/*****************************************************************************/

void main()
{
    s16 cnt=2;

    if (brd_init(100))   
        return;

	/* blink the leds a couple times */
	while ( cnt-- )
	{
		brd_led_toggle(BRD_LED0);
		/* brd_delay_msec(1000); */
		delay(1000);
		brd_led_toggle(BRD_LED1);
		/* brd_delay_msec(1000); */
		delay(1000);
		brd_led_toggle(BRD_LED2);
		/* brd_delay_msec(1000); */
		delay(1000);
	}


    /* Open Handset Codec */
    hHandset = codec_open(HANDSET_CODEC);               /* Acquire handle to codec */

    /* Set codec parameters */
    codec_dac_mode(hHandset, CODEC_DAC_15BIT);          /* DAC in 15-bit mode */
    codec_adc_mode(hHandset, CODEC_ADC_15BIT);          /* ADC in 15-bit mode */
    codec_ain_gain(hHandset, CODEC_AIN_6dB);            /* 6dB gain on analog input to ADC */
    codec_aout_gain(hHandset, CODEC_AOUT_MINUS_6dB);    /* -6dB gain on analog output from DAC */
    codec_sample_rate(hHandset,SR_16000);               /* 16KHz sampling rate */


    /* Polling and digital loopback */
    while (1)
    {
       /* Wait for sample from handset */
       while (!MCBSP_RRDY(HANDSET_CODEC)) {};

       /* Read sample from and write back to handset codec */
       data = *(volatile u16*)DRR1_ADDR(HANDSET_CODEC);
       *(volatile u16*)DXR1_ADDR(HANDSET_CODEC) = data;
    }
}


void delay(s16 period)
{
    int i, j;
    
    for(i=0; i<period; i++)
    {
        for(j=0; j<period>>1; j++);
    }
}                                                                              
