/*#############################################################################
## $Id: codec.cmd,v 1.1.1.1 2000/02/02 22:02:33 linton Exp $
##
###############################################################################
##      Copyright (c) 1999 DNA Enterprises, Inc.
###############################################################################
## Revision History
## ----------------
##  $Log: codec.cmd,v $
##  Revision 1.1.1.1  2000/02/02 22:02:33  linton
##  New/Updated codec example for C5000 V1.2
##
##
###############################################################################
###############################################################################
## XFERMAKE.CMD
## ------------
## C54x Linker Command File for 5402 DSK Memory Transfer Module
##
#############################################################################*/

/*****************************************************************************/
/* Object Files                                                              */
/*****************************************************************************/


/*****************************************************************************/
/* Linker Options                                                            */
/*****************************************************************************/


/*****************************************************************************/
/* C5402 DSK DSP Memory Map                                                  */
/*                                                                           */
/*****************************************************************************/

MEMORY
{
   PAGE 0: VECS:     origin = 0080h, length = 0080h  /* Internal Program RAM */
           PRAM:     origin = 7600h, length = 8000h  /* Internal Program RAM */

   PAGE 1: SCRATCH:  origin = 0060h, length = 0020h  /* Scratch Pad Data RAM */
           DMARAM:   origin = 0C00h, length = 0300h  /* DMA buffer */
           DATA:     origin = 1100h, length = 0080h  /* Internal Data RAM    */
           STACK:    origin = 1180h, length = 0560h  /* Stack Memory Space   */
           INRAM:    origin = 1900h, length = 0100h  /* Internal Data RAM    */
           HPRAM0:   origin = 1A00h, length = 0002h  /* HPI memory accessible by Host and DSP */
           HPRAM1:   origin = 1A02h, length = 0280h  /* HPI memory accessible by Host and DSP */
           HPRAM2:   origin = 1C82h, length = 0280h  /* HPI memory accessible by Host and DSP */
           EXRAM:    origin = 1F10h, length = 4000h  /* External Data RAM    */
}

/*****************************************************************************/
/* DSP Memory Allocation                                                     */
/*****************************************************************************/

SECTIONS
{
   .cinit    > PRAM  PAGE 0
   .text     > PRAM  PAGE 0
   .vectors  > VECS  PAGE 0
    
   init_var  > PRAM  PAGE 0
   detect    > PRAM  PAGE 0
   vrcprg	 > PRAM  PAGE 0
   matprg	 > PRAM  PAGE 0
   	
   .stack    > STACK PAGE 1
   .trap     > SCRATCH PAGE 1

   .const    > EXRAM PAGE 1
   .data     > EXRAM PAGE 1
   .bss      > EXRAM PAGE 1
   .cio      > EXRAM PAGE 1

   .switch   > EXRAM PAGE 1
   
   tables    > EXRAM PAGE 1
   var       > EXRAM PAGE 1
   svctab    > EXRAM PAGE 1         /* SS_V LSP table */
   vctab     > EXRAM PAGE 1         /* V LSP table */
   uvctab    > EXRAM PAGE 1         /* UV LSP table */
   cuvtab    > EXRAM PAGE 1         /* Stochastic codebook */
   cdbktab   > EXRAM PAGE 1         /* various codebook tables*/
   
   logtab    > EXRAM PAGE 1          /* table for log2 */
   powtab    > EXRAM PAGE 1          /* table for pow2 */
   hamtab    > EXRAM PAGE 1          /* table for hamming */
   lgwtab    > EXRAM PAGE 1          /* table for lag window */
   acostab   > EXRAM PAGE 1          /* table for arccos */
   sqrtab    > EXRAM PAGE 1          /* table for square root */
   acbtab    > EXRAM PAGE 1          /* table for thresholds in acb */
   pm03tab   > EXRAM PAGE 1          /* table for x^(-0.3) computation */
   costab    > EXRAM PAGE 1          /* table for cosine */

   V23       > INRAM PAGE 1
   FSK       > INRAM PAGE 1

   hpibuff0  > HPRAM0 PAGE 1
   hpibuff1  > HPRAM1 PAGE 1
   hpibuff2  > HPRAM2 PAGE 1
   dma_buff  > DMARAM PAGE 1
}