;
;Set up watch window for analysis registers
;
wa anaenbl,   Analysis Enable,x
wa wp0_addr,  WatchP0_Addr,x
wa wp0_amask, WatchP0_Amask,x
wa wp0_data,  WatchP0_Data,x
wa wp0_dmask, WatchP0_Dmask,x
wa wp0_ctrl,  WatchP0_Control,x
wa wp0_cmask, WatchP0_Cmask,x

wa wp1_addr,  WatchP1_Addr,x
wa wp1_amask, WatchP1_Amask,x
wa wp1_data,  WatchP1_Data,x
wa wp1_dmask, WatchP1_Dmask,x
wa wp1_ctrl,  WatchP1_Control,x
wa wp1_cmask, WatchP1_Cmask,x

;
;Setup aliases for analysis interface control
;
alias  asys_on,       "e anaenbl |= 0x0001"
alias  asys_off,      "e anaenbl &= 0xfffe"
alias  asys_emu0out,  "e anaenbl |= 0x0010"
alias  asys_emu1out,  "e anaenbl |= 0x0020"
alias  asys_emu0in,   "e anaenbl |= 0x0100"
alias  asys_emu1in,   "e anaenbl |= 0x0200"
alias  asys_trig_emu0,"e anaenbl |= 0x1000"
alias  asys_trig_emu1,"e anaenbl |= 0x2000"


echo Access Analysis Registers:
echo Initializing....
echo


e ANAENBL   = 0 
e wp0_addr  = 0xFFFFFFFF
e wp0_amask = 0xFFFFFFFF
e wp0_data  = 0xFFFFFFFF
e wp0_dmask = 0xFFFFFFFF
e wp0_ctrl  = 0xFFFFFEFF
e wp0_cmask = 0xFFFFFFFF

e wp1_addr  = 0xFFFFFFFF
e wp1_amask = 0xFFFFFFFF
e wp1_data  = 0xFFFFFFFF
e wp1_dmask = 0xFFFFFFFF
e wp1_ctrl  = 0xFFFFFEFF
e wp1_cmask = 0xFFFFFFFF

echo Analysis Registers....
echo Initialized 
