************************************************************************
* - Target (Assembly version) Write Test (ta_write.asm)                *
* - Transmits 100 integers, one at a time.                             *
* - Uses ONE output channel.                                           *
*                                                                      *
* - Tests Data transmission from target to host at the User layer.     *
************************************************************************
      .mmregs
FP    .set   AR7
      .title "Target Write Test for C54x"

************************ RTDX User layer *******************************
      .include "rtdx.i"                 ; include RTDX macro library
************************************************************************

        .sect   ".const"
SL1:    .string	13,"Can't get buffer space",0
SL2:    .string	13,"Test Completed",0
MAX_ITERATIONS	.set	100

        RTDX_output_channel     ochan   ; Declare output channel "ochan"
        .sect   ".text"
        .global	_main
        .ref    _puts
        .ref    _exit
        .ref    _RTDX_writing
        .ref    _RTDX_Poll
        .def    i
        .bss    i,1,0,0
************************************************************************
* FUNCTION DEF: _main                                                  *
************************************************************************
_main:
        PSHM    AR7
        RTDX_Enable_Data_Output ochan   ; Enable output channel "ochan"
        ST      #0,*(i)                 ; initialize our counter to 0

WRITE_DATA:
        STM     i,AR7
        RTDX_Data_Write ochan,AR7,#1    ; Write data to host
        STLM    A,AR2                   ; store return value in register
                                        ;     AR2
        nop
        nop
        BANZ TEST_DATA_TRANSMITTED,*AR2 ; branch to test data
                                        ;     transmitted
                                        ; if return value is not=0
        LD      #SL1,A                  ; load message "Can't get buffer
                                        ;     space"
        CALL    #_puts                  ; print message
        LD      #1,A                    ; load exit status
        CALL    #_exit                  ; call function exit

TEST_DATA_TRANSMITTED:
        LD      *(_RTDX_writing),B      ; load data transfer status
        CC      #_RTDX_Poll,BNEQ        ; poll if the contents of
                                        ;     register B NOT = NULL
        BC      TEST_DATA_TRANSMITTED,BNEQ    ; loop

TEST_ITERATIONS:
        LD      *(i),A                  ; load counter into accumulator
        ADD     #1,A                    ; increment the accumulator
        STLM    A,AR2                   ; store accumulator a (low) into
                                        ;     register AR2
        nop
        STM     MAX_ITERATIONS,AR0      ; store max iterations into
                                        ;     register AR0
        CMPR    1,AR2                   ; test to see if the contents of
                                        ;     register AR0 are less
                                        ;     than the contents of
                                        ;     register AR2
        BCD     WRITE_DATA,TC           ; delayed branch to data write
                                        ;     if true
        MVMD    AR2,*(i)                ; update counter with new value
        RTDX_Disable_Data_Output  ochan ; Disable output channel
        LD      #SL2,A                  ; load message "Test Completed"
        CALL    #_puts                  ; print message

        POPM    AR7
        RET