// MFCCatchRTDXEventsDlg.cpp : implementation file
//

#include "stdafx.h"
#include "MFCCatchRTDXEvents.h"
#include "MFCCatchRTDXEventsDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMFCCatchRTDXEventsDlg dialog

CMFCCatchRTDXEventsDlg::CMFCCatchRTDXEventsDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMFCCatchRTDXEventsDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMFCCatchRTDXEventsDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMFCCatchRTDXEventsDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMFCCatchRTDXEventsDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMFCCatchRTDXEventsDlg, CDialog)
	//{{AFX_MSG_MAP(CMFCCatchRTDXEventsDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_CHECK_CAPTURE_RTDX_EVENTS, OnCaptureRtdxEvents)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMFCCatchRTDXEventsDlg message handlers

BOOL CMFCCatchRTDXEventsDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMFCCatchRTDXEventsDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMFCCatchRTDXEventsDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMFCCatchRTDXEventsDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CMFCCatchRTDXEventsDlg::OnCaptureRtdxEvents() 
{
	TCHAR strCapturingRtdxEvents[] = _T("Capturing RTDX Events");
	TCHAR strNotCapturingRtdxEvents[] = _T("Not Capturing RTDX Events");
	HWND hCtrlWnd = NULL;
	
	this->GetDlgItem(IDC_CHECK_CAPTURE_RTDX_EVENTS,&hCtrlWnd);

	if (this->IsDlgButtonChecked(IDC_CHECK_CAPTURE_RTDX_EVENTS)) {
		if (SUCCEEDED(GetPointers2RTDXInterfaces()))
			::SetWindowText(hCtrlWnd,strCapturingRtdxEvents);
	} else {
		if (SUCCEEDED(ReleasePointers2RTDXInterfaces()))
			::SetWindowText(hCtrlWnd,strNotCapturingRtdxEvents);
	}
		
	return;
}

HRESULT CMFCCatchRTDXEventsDlg::GetPointers2RTDXInterfaces()
{
	IApplicationPtr         cc_app;
	VARIANT                 index;
	HRESULT                 hr      = S_OK;
	VariantInit(&index);
	index.vt                        = VT_I2;
	index.iVal                      = 0;
	
	// Initialize COM
	::CoInitialize(NULL);

	// Create an instance of the CodeComposer::Application coclase and
	// obtain a pointer to the IApplication interface
	hr = cc_app.CreateInstance(__uuidof(CodeComposer::Application),
									NULL,
									CLSCTX_LOCAL_SERVER);
	if (FAILED(hr))
		return hr;

	// Make sure Code Composer is visible
	cc_app->PutVisible(VARIANT_TRUE);


	// Get pointer to CodeComposer::IRtdx interface
	m_pRtdx = cc_app->GetDspBoards()->Item(index)->GetDspTasks()->Item(index)->Getrtdx();

	// Release pointer to CodeComposer::IApplication interface
	cc_app.Release();		

	// Setup to receive event notification from CodeComposer::IRtdxEvents
	hr = ConnectRtdxEvents();
	if (FAILED(hr))
		return hr;
	return hr;
}

HRESULT CMFCCatchRTDXEventsDlg::ReleasePointers2RTDXInterfaces()
{
	HRESULT hr=S_OK;

	// Disconnect link from receiving event notification from
	// CodeComposer::IRtdxEvents
	hr = DisConnectRtdxEvents();
	if (FAILED(hr))
		return hr;

	// release reference to CodeComposer::IRtdx interface
	if (m_pRtdx) {
		m_pRtdx.Release();
		m_pRtdx = NULL;
	}
	return hr;
}

HRESULT CMFCCatchRTDXEventsDlg::ConnectRtdxEvents()
{
	IConnectionPointContainer   *pConnPtContainer = NULL;
	LPUNKNOWN                   pUnk              = NULL;
	HRESULT                     hr                = S_OK;

	
	// create an instance of your sink class and obtain a pointer to its
	// interface
	m_pRtdxEventsSink = new CRtdxEventsSink;
	if (m_pRtdxEventsSink == NULL)
		return E_FAIL;


	// Query for connection point container
	hr = m_pRtdx.QueryInterface(IID_IConnectionPointContainer, (void **)&pConnPtContainer);
	if (FAILED(hr))
		return hr;

	// Find connection point for IRtdxEvents 
	hr = pConnPtContainer->FindConnectionPoint(__uuidof(CodeComposer::IRtdxEvents), &m_pConnectionPoint);
	if (FAILED(hr)) {
		pConnPtContainer->Release();
		return hr;
	}
	pConnPtContainer->Release();

	
	// Get pointer to IUnknown interface from IRtdxEvent Sink interface
	pUnk = m_pRtdxEventsSink->GetInterface(&IID_IUnknown);
	if (FAILED(hr)) {
		m_pConnectionPoint->Release();
		return hr;
	}

	hr = m_pConnectionPoint->Advise(pUnk, &m_dwRtdxEventsCookie);
	if (FAILED(hr)) {
		m_pConnectionPoint->Release();
		pUnk->Release();
		return hr;
	}

	pUnk->Release();
	return hr;
}

HRESULT CMFCCatchRTDXEventsDlg::DisConnectRtdxEvents()
{
	HRESULT hr= S_OK;
	hr = m_pConnectionPoint->Unadvise(m_dwRtdxEventsCookie);
	if (FAILED(hr)) {
		m_pConnectionPoint->Release();
		return hr;
	}

	m_pConnectionPoint->Release();
	
	// Notice that we do not free m_pRtdxEventsSink.  The reason for this
	// is because the function Unadvise does this for us.

	return hr;
}
