;               TMS370C16 REALTIME MODE SUPPORT FOR XDS511
;
; The C16 XDS511 product supports a basic form of realtime emulation. This
; allows the user to view and modify memory while the target processor
; is running. These memory accesses are non-intrusive to the application as
; they occur during dead cycles.
;
;
; Three new commands have been added to the debugger to support realtime
; mode operation. They are :
;
;     realtime  - Enters realtime operating mode
;     stopmode  - Exits realtime mode
;     update    - Sets the screen update rate
;
;
; The command 'REALTIME  <address>', is used to switch into real-time mode
; from stop-mode. The "address" parameter is not required for the C16
; and should be set to 0.
;
; The command 'STOPMODE' is used to switch back from real-time mode to
; stop-mode emulation.
;
; A command 'UPDATE' has been added to select which windows are updated, 
; and when the update occurs.
;
; A fourth debugging mode, Minimal, has been added to Auto, Assembly and
; Mixed. The Minimal mode displays only the COMMAND window, and the 
; WATCH/DISP windows if they have been created by the WA and DISP commands. 
; This mode can be specified when the HLL Debugger starts by specifying
; at the command line the option '-min', or any time it is running
; by specifying in the command window the command 'MINIMAL', or
; through the Minimal menu item in the Mode Menu. This mode can be very 
; useful when running in realtime mode.
;
; The 'UPDATE' command can: disable the updating of windows; enable the
; WATCH window alone to be updated; or enable all the MEMORY, DISP
; and WATCH windows to be updated. These choices are made by specifying
; in the command window the commands 'UPDATE OFF', 'UPDATE WATCH' and
; 'UPDATE ALL'. If UPDATE ALL is chosen in the realtime mode, the CPU 
; window will become invalid when the processor starts running but restores 
; to the nomal when the CPU is halted.  
;
; The updates may be done manually when requested by the user - this is used
; when the 'UPDATE OFF' command has disabled automatic updating. This choice
; is made by specifying in the command window the command 'UPDATE'.
; Updates may also be done automatically in some multiple of tenths of a
; second - this is used when the 'UPDATE WATCH' and 'UPDATE ALL' commands have
; enabled automatic updating. This choice is made by specifying in the
; command window the command 'UPDATE n', where n is a multiple of tenths of
; a second.
;
; When the debugger is first started the update state is 'UPDATE WATCH'.
;
; When you enter realtime mode there is no visible change to debugger
; operation until you enter the run command. After you enter the run command
; the command will be started and the keyboard freed. Thus you can enter
; other debugger commands from the command line. Debugger commands are
; not blocked so the user has to take care. It is suggested that you limit
; debugger commands to watch and memory commands to display and modify
; memory when running in realtime mode. 
;
; Breakpoints should be used carefully in the realtime mode. Illegal 
; interruption reset might happen when breakpoint is detected while trying
; to perform a memory write function. When the CPU cycle detects a breakpoint 
; the CPU will be stopped at that address, but at the same time the CMA cycle 
; finishes the memory write and tries to restart the CPU. Therefore invailid 
; instructions are fetched. A workaround solution is to use BTT software and 
; to set hardware breakpoints from BTT.  
;============================================================================
; C16 REALTIME MACROS: The following macros are added as short cuts.
;
; rtm       : Enable realtime mode
; stm       : Enable stop mode
; upd %1    : Set the realtime screen update rate

alias rtm,     "realtime 0"
alias stm,     "halt; stopmode " ; Halt must precede stopmode command
alias upd,     "update %1 "

