************************************************************************
* - RTDX Include file - interface to 'C54x ASM.                        *
************************************************************************
      .width  80
      .length 55
      .title      "RTDX interface to 'C54x ASM"

***************************** Error Checking ****************************
Error_Check                     .macro param,level

SYMCHECK1    .set   1
SYMCHECK2    .set   2
SYMCHECK3    .set   3

      ; Check for level 1 testing
      .asg       level,SYMPARAM
      .if        SYMPARAM >= SYMCHECK1
      .if        ($symlen(param) == 0)        ; ensure parameter given
      .emsg      "ERROR -- Missing parameter
      .endif
      .endif

      ; Check for level 1 & 2 testing
      .if        SYMPARAM >= SYMCHECK2
      .if        ($isname(param) == 0)        ; ensure parameter is a
                                              ;     valid symbol name
      .emsg      "ERROR -- Invalid symbol name given as argument"
      .endif
      .endif

      ; Check for level 1,2 & 3 testing
      .if        SYMPARAM >= SYMCHECK3
      .if        ($isdefed(param) == 0)       ; ensure parameter is
                                              ;     a defined symbol
      .emsg      "ERROR -- Undefined Symbol given as argument"
      .endif
      .endif
      .endm

****************************** Data Macros ******************************

RTDX_input_channel              .macro ichan
      Error_Check ichan,2
      
      .def        ichan
      .bss        ichan,3,0,0
      .endm

RTDX_output_channel             .macro ochan
      Error_Check ochan,2
      
      .def        ochan
      .bss        ochan,3,0,0
      .endm

RTDX_event                      .macro event,class
      Error_Check event,2
      Error_Check class,1
      
      .sect       ".cinit"
      .align      1
      .field      1,16
      .field      event+0,16
      .field      class,16
      .sect       ".text"
      .global     event
      .bss        event,1,0,0
      .endm

RTDX_e_class_set        .macro eclass
      Error_Check eclass,2
      
      .def        eclass
      .bss        eclass,1,0,0
      .endm

**************************** Function Macros ****************************

RTDX_Enable_Data_Output	        .macro ochan
      Error_Check ochan,3
      
      SSBX        CPL                           ; set the CPL bit
      .ref        _RTDX_Enable_Data_Output
      LD          #ochan,A
      .if         __far_mode
      FCALL       #_RTDX_Enable_Data_Output
      .else
      CALL        #_RTDX_Enable_Data_Output
      .endif
      .endm

RTDX_Disable_Data_Output        .macro ochan
      Error_Check ochan,3

      SSBX        CPL                           ; set the CPL bit      
      .ref        _RTDX_Disable_Data_Output
      LD          #ochan,A
      .if         __far_mode
      FCALL       #_RTDX_Disable_Data_Output
      .else
      CALL        #_RTDX_Disable_Data_Output
      .endif
      .endm

RTDX_Enable_Data_Input          .macro ichan
      Error_Check ichan,3
      
      SSBX        CPL                           ; set the CPL bit
      .ref        _RTDX_Enable_Data_Input
      LD          #ichan,A
      .if         __far_mode
      FCALL       #_RTDX_Enable_Data_Input
      .else
      CALL        #_RTDX_Enable_Data_Input
      .endif
      .endm

RTDX_Disable_Data_Input	        .macro ichan
      Error_Check ichan,3
      
      SSBX        CPL                           ; set the CPL bit
      .ref        _RTDX_Disable_Data_Input
      LD          #ichan,A
      .if         __far_mode
      FCALL       #_RTDX_Disable_Data_Input
      .else
      CALL        #_RTDX_Disable_Data_Input
      .endif
      .endm

RTDX_Enable_Event_Class	        .macro eclass
      Error_Check eclass,3

      SSBX        CPL                           ; set the CPL bit
      .ref        _RTDX_Enable_Event_Class
      LD          eclass,A
      .if         __far_mode
      FCALL       #_RTDX_Enable_Event_Class
      .else
      CALL        #_RTDX_Enable_Event_Class
      .endif
      .endm

RTDX_Disable_Event_Class        .macro eclass
      Error_Check eclass,3

      SSBX        CPL                           ; set the CPL bit
      .ref        _RTDX_Disable_Event_Class
      LD          eclass,A
      .if         __far_mode
      FCALL       #_RTDX_Disable_Event_Class
      .else
      CALL        #_RTDX_Disable_Event_Class
      .endif
      .endm

RTDX_Data_Write                 .macro ochan,buffptr,bsize
      Error_Check ochan,3
      Error_Check buffptr,1
      Error_Check bsize,1
      
      SSBX        CPL                           ; set the CPL bit
      .ref        _RTDX_Data_Write

* Testing to see if parameter 3 is a register or memory address
      .if         ($isreg(bsize))
      PSHM        bsize
      .else
      STM         bsize,BL
      PSHM        BL
      .endif

* Testing to see if parameter 2 is a register or memory address
      .if         ($isreg(buffptr))     
      PSHM        buffptr
      .else
      STM         buffptr,BL
      PSHM        BL
      .endif

* Call the RTDX data write function
      LD          #ochan,A
      .if         __far_mode
      FCALL       #_RTDX_Data_Write
      .else
      CALL        #_RTDX_Data_Write             ; return param in
                                                ;     register A
      .endif

* Testing to see if parameter 2 is a register or memory address
      .if         ($isreg(buffptr))
      POPM        buffptr
      .else
      POPM        BL
      .endif

* Testing to see if parameter 3 is a register or memory address
      .if         ($isreg(bsize))
      POPM        bsize
      .else
      POPM        BL
      .endif
      .endm
    
RTDX_Data_Read                  .macro ichan,buffptr,bsize
      Error_Check ichan,3
      Error_Check buffptr,1
      Error_Check bsize,1

      SSBX        CPL                           ; set the CPL bit
      .ref        _RTDX_Data_Read

* Testing to see if parameter 3 is a register or memory address
      .if         ($isreg(bsize))
      PSHM        bsize
      .else
      STM         bsize,BL
      PSHM        BL
      .endif

* Testing to see if parameter 2 is a register or memory address
      .if         ($isreg(buffptr))     
      PSHM        buffptr
      .else
      STM         buffptr,BL
      PSHM        BL
      .endif

* Call the RTDX read function
      LD          #ichan,A
      .if         __far_mode
      FCALL       #_RTDX_Data_Read
      .else
      CALL        #_RTDX_Data_Read              ; return param in
                                                ;     register A
      .endif

* Testing to see if parameter 2 is a register or memory address
      .if         ($isreg(buffptr))
      POPM        buffptr
      .else
      POPM        BL
      .endif

* Testing to see if parameter 3 is a register or memory address
      .if         ($isreg(bsize))
      POPM        bsize
      .else
      POPM        BL
      .endif
      .endm

RTDX_Data_Read_NB               .macro ichan,buffptr,bsize
      Error_Check ichan,3
      Error_Check buffptr,1
      Error_Check bsize,1

      SSBX        CPL                           ; set the CPL bit
      .ref        _RTDX_Data_Read_NB

* Testing to see if parameter 3 is a register or memory address
      .if         ($isreg(bsize))
      PSHM        bsize
      .else
      STM         bsize,BL
      PSHM        BL
      .endif

* Testing to see if parameter 2 is a register or memory address
      .if         ($isreg(buffptr))     
      PSHM        buffptr
      .else
      STM         buffptr,BL
      PSHM        BL
      .endif

* Call the RTDX non-blocking read function

      LD          #ichan,A
      .if         __far_mode
      FCALL       #_RTDX_Data_Read_NB
      .else
      CALL        #_RTDX_Data_Read_NB           ; return param in
                                                ;     register A
      .endif

* Testing to see if parameter 2 is a register or memory address
      .if         ($isreg(buffptr))
      POPM        buffptr
      .else
      POPM        BL
      .endif

* Testing to see if parameter 3 is a register or memory address
      .if         ($isreg(bsize))
      POPM        bsize
      .else
      POPM        BL
      .endif
      .endm

RTDX_Channel_Busy               .macro chan
      Error_Check chan,3

      SSBX        CPL                           ; set the CPL bit
      LD          chan,A
      .endm

RTDX_Bytes_Read                 .macro ichan,bsize
      Error_Check ichan,3
      Error_Check bsize,1

      SSBX        CPL                           ; set the CPL bit
      CMPM        ichan,bsize
      .endm

RTDX_Log_Event                  .macro event
      Error_Check event,3

      SSBX        CPL                           ; set the CPL bit
      .ref        _RTDX_Log_Event_Data
      STM         #0,BL
      PSHM        BL
      STM         #0,BL
      PSHM        BL
      LD          #event,A
      .if         __far_mode
      FCALL       #_RTDX_Log_Event_Data
      .else
      CALL        #_RTDX_Log_Event_Data
      .endif
      POPM        BL
      POPM        BL
      .endm

RTDX_Log_Event_Data             .macro event,buffptr,bsize
      Error_Check event,3
      Error_Check buffptr,1
      Error_Check bsize,1

      SSBX        CPL                           ; set the CPL bit
      .ref        _RTDX_Log_Event_Data

* Testing to see if parameter 3 is a register or memory address
      .if         ($isreg(bsize))
      PSHM        bsize
      .else
      STM         bsize,BL
      PSHM        BL
      .endif

* Testing to see if parameter 2 is a register or memory address
      .if         ($isreg(buffptr))     
      PSHM        buffptr
      .else
      STM         buffptr,BL
      PSHM        BL
      .endif

* Call the RTDX log event function
      LD          #event,A
      .if         __far_mode
      FCALL       #_RTDX_Log_Event_Data
      .else
      CALL        #_RTDX_Log_Event_Data         ; return param in
                                                ;     register A
      .endif

* Testing to see if parameter 2 is a register or memory address
      .if         ($isreg(buffptr))
      POPM        buffptr
      .else
      POPM        BL
      .endif

* Testing to see if parameter 3 is a register or memory address
      .if         ($isreg(bsize))
      POPM        bsize
      .else
      POPM        BL
      .endif
      .endm