/********************************************************************/
/* math.h C16 V 2.04                                                */
/* Copyright (c) 1992,1997 Texas Instruments Incorporated           */
/********************************************************************/
#ifndef _MATH
#define _MATH

#if _INLINE
#define __INLINE static inline
#else
#define __INLINE
#endif

#define HUGE_VAL  3.40282347E+38F   /* SAME AS DBL_MAX */

#ifndef EDOM
#define EDOM   1
#endif

#ifndef ERANGE
#define ERANGE 2
#endif

/***************************************************************/
/* FUNCTION DEFINITIONS.                                       */
/***************************************************************/
         double asin(double _x);
         double acos(double _x);
         double atan(double _x);
         double atan2(double _y, double _x);
__INLINE double ceil(double _x);
         double cos(double _x);
         double cosh(double _x);
         double exp(double _x);
         double fabs(double _x); 
__INLINE double floor(double _x);
         double fmod(double _x, double _y);
         double frexp(double _x, int *_exp);
         double ldexp(double _x, int _exp);
         double log(double _x);
         double log10(double _x);
         double modf(double _x, double *_y); 
         double pow(double _x, double _y);
         double sin(double _x);
         double sinh(double _x);
         double sqrt(double _x);   
         double tan(double _x);
         double tanh(double _x);

#if _INLINE

/****************************************************************************/
/*  ceil   v0.00                                                            */
/****************************************************************************/
__INLINE double ceil(double x)
{
     double y; 
     return (modf(x, &y) > 0 ? y + 1 : y);
}

/****************************************************************************/
/*  floor  v0.00                                                            */
/****************************************************************************/
__INLINE double floor(double x) 
{
     double y; 
     return (modf(x, &y) < 0 ? y - 1 : y);
}

#endif 

#undef __INLINE

#endif 
